package gov.va.vamf.scheduling.direct.resource;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.veteranappointment.resources.AbstractUserResource;
import gov.va.vamf.scheduling.direct.datalayer.profile.ClinicProfileService;
import gov.va.vamf.scheduling.direct.domain.ClinicProfile;
import gov.va.vamf.security.v1.filters.JwtResourceRestricted;
import gov.va.vamf.security.v1.filters.PatientSensitive;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import javax.ws.rs.*;

@Path("/clinic-service")
@Component
@Scope("request")
@JwtResourceRestricted
public class ClinicProfileResource extends AbstractUserResource {

    @Resource
    ClinicProfileService clinicProfileService;

    /**
     * Extract the Clinic Profile data embedded in the MDWS getClinicSchedulingDetail() when fetching available slots
     *
     * @param siteCode
     * @param clinicId
     * @param assigningAuthority
     * @param patientId

     * @return ClinicProfile
     */
    @GET
    @Path("/patient/{assigning-authority}/{patient-id}/site/{site-code}/clinic-profile/{clinic-id}")
    @Produces({"application/xml", "application/json"})
    public ClinicProfile fetchClinicProfile(@PathParam("site-code") String siteCode,
                                            @PathParam("clinic-id") String clinicId,
                                            @PathParam("assigning-authority") String assigningAuthority,
                                            @PathParam("patient-id") String patientId) {

        PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority, patientId);

        return clinicProfileService.fetchClinicProfile(siteCode, clinicId, patientIdentifier);
    }
}
